//
//  GSMetric.h
//  GlyphsCore
//
//  Created by Georg Seifert on 18.08.18.
//  Copyright © 2018 schriftgestaltung.de. All rights reserved.
//

#if !defined(GLYPHS_LITE) && !defined(LIBCORE)
#import <GlyphsCore/GSIdentifiableParameter.h>
#endif
#import <Foundation/Foundation.h>
#import <GlyphsCore/GSBase.h>
#import <GlyphsCore/GSContainerProtocol.h>

NS_ASSUME_NONNULL_BEGIN

typedef NSString *GSMetricsKey NS_EXTENSIBLE_STRING_ENUM;

extern GSMetricsKey GSMetricsKeyAscender;
extern GSMetricsKey GSMetricsKeyCapHeight;
extern GSMetricsKey GSMetricsKeySlantHeight; // defaults to half xHeight
extern GSMetricsKey GSMetricsKeyxHeight;
extern GSMetricsKey GSMetricsKeyMidHeight;
extern GSMetricsKey GSMetricsKeyTopHeight;	// old key
extern GSMetricsKey GSMetricsKeyBodyHeight; // global top boundary, can be xHeight, CapHeight, ShoulderHeight...
extern GSMetricsKey GSMetricsKeyDescender;
extern GSMetricsKey GSMetricsKeyBaseline;
extern GSMetricsKey GSMetricsKeyItalicAngle;

// make sure that the numbers are in sync with the tags in the metrics type popup in font info
typedef NS_ENUM(uint8_t, GSMetricsType) {
	GSMetricsTypeUndefined = 0,
	GSMetricsTypeAscender = 1,
	GSMetricsTypeCapHeight = 2,
	GSMetricsTypeSlantHeight = 3,
	GSMetricsTypexHeight = 4,
	GSMetricsTypeMidHeight = 5,
	GSMetricsTypeBodyHeight = 6,
	GSMetricsTypeDescender = 7,
	GSMetricsTypeBaseline = 8,
	GSMetricsTypeItalicAngle = 9
};

@protocol GSContainerProtocol;
#if !defined(GLYPHS_LITE) && !defined(LIBCORE)
/// metrics value entry
@interface GSMetric : NSObject <GSIdentifiableParameter>
#else
@interface GSMetric : NSObject
#endif
{
	GSMetricsType _type;
	NSString *_name;
	NSPredicate *_filter;
	BOOL _horizontal;
}
/// init from property list
- (instancetype)initWithDict:(NSDictionary *)dict format:(GSFormatVersion)formatVersion;

- (instancetype)initWithHorizontal:(BOOL)horizontal index:(int)index;

- (BOOL)isEqualToMetric:(GSMetric *)object;

/** Returns the content of the object to store it in pList.

 This is used to store the data in the .glyphs file.
 @param format the version of the dict
 */
- (NSDictionary *)propertyListValueFormat:(GSFormatVersion)format;

/// access to the containing font
@property (weak, nonatomic, nullable) GSContainer *font;

/// the metrics type
@property (nonatomic, assign) GSMetricsType type;

@property (nonatomic, strong) NSString *typeName;

@property (nonatomic, readonly) BOOL isDefaultType;

// the manually typed name. This is only a descriptive value
@property (nonatomic, strong, nullable) NSString *name;

/// the descriptive elements as shown in the UI
@property (nonatomic, readonly) NSArray *titles;

/// the descriptive name as shown in the UI
@property (nonatomic, readonly) NSString *title;

/// a unique identifier
@property (nonatomic, strong) NSString *id;

@property (nonatomic, readonly) NSString *identifier;

- (NSString *)noFilterId;

/// a filter that allows to show the guide only in certain glyphs
@property (nonatomic, strong, nullable) NSPredicate *filter;
/// convenient setter to use predicate string to set the filter
- (void)setFilterString:(NSString *)filterString;

/// The horizontal.
@property (nonatomic) BOOL horizontal;

+ (GSMetricsKey)typeNameForType:(GSMetricsType)type;
+ (GSMetricsType)typeForTypeName:(GSMetricsKey)name;

/// e.g. Ascender but not italic angle
@property (readonly) BOOL isVerticalMetric;

@end
NS_ASSUME_NONNULL_END
